import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Define the properties of the tiles and robot
tiles = [
    {'id': 'tile_0-0', 'pos': (0, 4), 'color': 'black', 'status': 'painted black'},
    {'id': 'tile_0-1', 'pos': (2, 4), 'color': 'white', 'status': 'painted white'},
    {'id': 'tile_0-2', 'pos': (4, 4), 'color': 'black', 'status': 'painted black'},
    {'id': 'tile_0-3', 'pos': (6, 4), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_0-4', 'pos': (8, 4), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_1-0', 'pos': (0, 2), 'color': 'lightgrey', 'status': 'clear'},
    {'id': 'tile_1-1', 'pos': (2, 2), 'color': 'lightgrey', 'status': 'clear'},
    {'id': 'tile_1-2', 'pos': (4, 2), 'color': 'lightgrey', 'status': 'clear'},
    {'id': 'tile_1-3', 'pos': (6, 2), 'color': 'lightgrey', 'status': 'occupied by robot1'},
    {'id': 'tile_1-4', 'pos': (8, 2), 'color': 'lightgrey', 'status': 'not painted'},
]

robot = {'id': 'robot1', 'pos': (6.5, 2.5), 'color': 'black', 'status': 'holding black paint gun'}

# Add tiles to the plot
for tile in tiles:
    rect = patches.Rectangle(tile['pos'], 2, 2, linewidth=1, edgecolor='black', facecolor=tile['color'])
    ax.add_patch(rect)
    ax.text(tile['pos'][0] + 0.1, tile['pos'][1] + 1.6, tile['id'], fontsize=8, verticalalignment='center', color='black')
    ax.text(tile['pos'][0] + 0.1, tile['pos'][1] + 0.6, tile['status'], fontsize=8, verticalalignment='center', color='black')

# Add robot to the plot
robot_rect = patches.Rectangle(robot['pos'], 1, 1, linewidth=1, edgecolor='black', facecolor=robot['color'], alpha=0.5)
ax.add_patch(robot_rect)
ax.text(robot['pos'][0] + 0.05, robot['pos'][1] + 0.7, robot['id'], fontsize=8, verticalalignment='center', color='black')
ax.text(robot['pos'][0] + 0.05, robot['pos'][1] + 0.2, robot['status'], fontsize=8, verticalalignment='center', color='black')

# Set limits and aspect
ax.set_xlim(-1, 11)
ax.set_ylim(0, 7)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles_instance_3/state_69/attempts/diagram_attempts/diagram_attempt_1.png', bbox_inches='tight')
plt.close()